-- List of grass entity models to detect
local grassPropModels   = {
"proc_drygrasses01b",
"prop_grass_ca",
"proc_grassdandelion01",
"proc_grasses01",
"proc_grassplantmix_02",
"prop_grass_da",
"proc_forest_grass01",
"proc_dryplantsgrass_01",
"proc_grasses01b",
"urbangrngrass_01",
"prop_grass_001_a",
"proc_drygrasses01",
"proc_dryplantsgrass_02",
"prop_tall_grass_ba",
"proc_grassplantmix_01",
"prop_tall_drygrass_aa",
"urbandrygrass_01",
"proc_drygrassfronds01",
"proc_grassfronds01",
"prop_veg_grass_01_b",
"prop_veg_grass_01_c",
"prop_veg_grass_01_a",
"prop_grass_dry_03",
"prop_veg_grass_01_d",
"prop_grass_dry_02",
"prop_veg_grass_02_a"
}


-- Variables for grass prop spawning
local grassAreaCenter = nil  -- Center position of the grass area
local grassAreaRadius = nil  -- Radius of the grass area
local grassProps = {} -- Table to store the spawned grass props

-- Function to check if a player is driving a mower
function IsDrivingMower(playerPed, vehicle)
    return DoesEntityExist(vehicle) and GetEntityModel(vehicle) == GetHashKey("mower")
end

-- Function to spawn grass props in the grass area
function SpawnGrassProps()
    local grassAreaStartX = grassAreaCenter.x - grassAreaRadius
    local grassAreaStartY = grassAreaCenter.y - grassAreaRadius
    local grassAreaEndX = grassAreaCenter.x + grassAreaRadius
    local grassAreaEndY = grassAreaCenter.y + grassAreaRadius

    for _, model in ipairs(grassPropModels) do
        local prop = CreateObject(GetHashKey(model), 0.0, 0.0, 0.0, true, false, true)

        -- Randomly position the grass prop within the grass area
        local posX = math.random() * (grassAreaEndX - grassAreaStartX) + grassAreaStartX
        local posY = math.random() * (grassAreaEndY - grassAreaStartY) + grassAreaStartY

        -- Process a raycast from above the prop to obtain the ground position
        local _, groundZ, _ = GetGroundZFor_3dCoord(posX, posY, 1000.0, false)

        if groundZ ~= 0 then
            SetEntityCoordsNoOffset(prop, posX, posY, groundZ + 0.01, false, false, true)
            PlaceObjectOnGroundProperly(prop)

            table.insert(grassProps, prop)

            -- Calculate the approximate height above ground
            local heightAboveGround = GetEntityCoords(prop).z - groundZ
            local propPos = GetEntityCoords(prop)
            print(string.format("Spawned grass prop: Model: %s, Position: %s, HeightAboveGround: %.2f", model, tostring(propPos), heightAboveGround))
        else
            print("Failed to get ground Z for grass prop.")
            DeleteGrassProp(prop)
        end
    end
end

-- Function to delete a grass prop
function DeleteGrassProp(prop)
    if DoesEntityExist(prop) then
        SetEntityAsMissionEntity(prop, true, true)

        DeleteEntity(prop)
    end
end

-- Command to set the grass area and spawn grass props
RegisterCommand("setgrasszone", function(source, args)
    local playerPed = PlayerPedId()
    local playerPos = GetEntityCoords(playerPed)

    if #args == 1 then
        local radius = tonumber(args[1])
        if radius ~= nil and radius > 0 then
            grassAreaCenter = playerPos
            grassAreaRadius = radius
            print("Grass zone set with center: " .. tostring(grassAreaCenter) .. ", radius: " .. tostring(grassAreaRadius))
            SpawnGrassProps()
        else
            print("Invalid radius. Please provide a positive number.")
        end
    else
        print("Invalid command. Usage: /setgrasszone [radius]")
    end
end)

-- Command to clear the grass in the grass zone
RegisterCommand("cleargrass", function(source, args)
    if grassProps ~= nil then
        for i = #grassProps, 1, -1 do
            local prop = grassProps[i]
            DeleteGrassProp(prop)
            table.remove(grassProps, i)
        end
        print("Cleared grass in the zone.")
    else
        print("No grass to clear.")
    end
end)

-- Toggle mower on/off
local isMowerActive = false
RegisterCommand("togglemower", function(source, args)
    isMowerActive = not isMowerActive
    if isMowerActive then
        print("Mower activated.")
    else
        print("Mower deactivated.")
    end
end)

-- Main loop to check if the player is driving a mower and delete grass props
Citizen.CreateThread(function()
    while true do
        Citizen.Wait(0)

        local playerPed = PlayerPedId()
        local vehicle = GetVehiclePedIsIn(playerPed, false)

        if IsDrivingMower(playerPed, vehicle) and isMowerActive and grassProps ~= nil then
            local playerPos = GetEntityCoords(playerPed)
            for i = #grassProps, 1, -1 do
                local prop = grassProps[i]
                if DoesEntityExist(prop) then
                    local propPos = GetEntityCoords(prop)
                    local _, groundZ, _ = GetGroundZFor_3dCoord(propPos.x, propPos.y, 1000.0, false)

                    if groundZ ~= 0 then
                        local heightAboveGround = propPos.z - groundZ
                        local distance = #(playerPos - propPos)
                        if distance <= 1.5 then
			    Wait(750)
                            DeleteGrassProp(prop)
                            table.remove(grassProps, i)
                        end
                    else
                        print("Failed to get ground Z for grass prop.")
                    end
                else
                    table.remove(grassProps, i)
                end
            end
        end
    end
end)