$(document).ready(function () {
  $('.notify-container').empty();
  $('.announce-container').empty();
  $('.bottom-notify-container').empty();
  $('.help-notify-container').empty();

  function notify(
    notifyType = 'notify',
    type = 'success',
    title,
    content = 'No message provided',
    time = 5000
  ) {
    let notifyID =
      Math.random().toString(36).substring(2, 15) +
      Math.random().toString(36).substring(2, 15);

    if (notifyType == 'notify') {
      $('.notify-container').append(`
        <div class="notify ${type} notify-id-${notifyID}" style="--notifyTime: ${time}ms;">
            <div class="notify-box">Notify</div>
            <div class="notify-content">
                <div class="notify-title">${
                  title || type.charAt(0).toUpperCase() + type.slice(1)
                }</div>
                <div class="notify-text">${content}</div>
            </div>
            ${
              type == 'lifeinvader'
                ? `
            <div class="notify-buttons">
            <div class="notify-button">
                <img src="assets/svg/call.svg" />
            </div>
            <div class="notify-button">
                <img src="assets/svg/message.svg" />
            </div>
        </div>
            `
                : ''
            }
            <div class="notify-progress">
                <div class="notify-progress-bar"></div>
            </div>
        </div>
        `);
    } else if (notifyType == 'announce') {
      let typeLabel = type.charAt(0).toUpperCase() + type.slice(1);
      $('.announce-container').append(`
      <div class="announce announce-id-${notifyID}" style="--progressBarTime: ${time}ms; animation: scaleIn 0.5s ease-in-out;">
        <img src="assets/svg/${type}.svg" />
        <div class="announce-column">
            <div class="announce-box">${typeLabel}</div>
            <div class="announce-text">${content}</div>
            <div class="announce-progress">
                <div class="announce-progress-bar"></div>
            </div>
        </div>
      </div>
      `);
    } else if (notifyType == 'progressbar') {
      $('.bottom-notify-container').append(`
      <div class="bottom-notify progressbar-id-${notifyID}" style="animation: slideInFromBottom 0.5s ease-in-out;">
        <div class="bottom-notify-box">
            <div class="bottom-notify-inbox">Loading</div>
            <span>${content}</span>
        </div>
        <div class="bottom-notify-box">
            <div class="bottom-notify-progress">
                <div class="bottom-notify-progress-bar" style="--progressBarTime: ${time}ms"></div>
            </div>
        </div>
      </div>
      `);
    } else if (notifyType == 'help') {
      let firstWord = content.split(' ')[0];
      let restWords = content.split(' ').slice(1).join(' ');
      let restWordsRemoveE = restWords.replace('E', '');
      let restWordsRemoveE2 = restWords.replace('~INPUT_CONTEXT~', '');
      $('.help-notify-container').append(`
        <div class="help-notify helpnotify-id-${notifyID}" style="animation: scaleIn 0.5s ease-in-out;">
          <img src="assets/svg/help.svg" />
          <div class="help-notify-column">
              <div class="help-notify-box">Help</div>
              ${title ? `<div class="help-notify-text">${title}</div>` : ''}
              <div class="help-notify-text2">
                  <span>${firstWord}</span>
                  <div class="help-notify-e-box">E</div>
                  <span>${restWordsRemoveE2}</span>
              </div>
          </div>
        </div>
      `);
    }

    setTimeout(function () {
      if (notifyType == 'notify') {
        $(`.notify-id-${notifyID}`).css(
          'animation',
          'slideOutToLeft 1s ease-in-out forwards'
        );

        setTimeout(function () {
          $(`.notify-id-${notifyID}`).remove();
        }, 1000);
      } else if (notifyType == 'announce') {
        $(`.announce-id-${notifyID}`).css(
          'animation',
          'scaleOut 0.5s ease-in-out forwards'
        );

        setTimeout(function () {
          $(`.announce-id-${notifyID}`).remove();
        }, 500);
      } else if (notifyType == 'progressbar') {
        $(`.progressbar-id-${notifyID}`).css(
          'animation',
          'slideOutToBottom 0.5s ease-in-out forwards'
        );

        setTimeout(function () {
          $(`.progressbar-id-${notifyID}`).remove();
        }, 500);
      }
    }, time);
  }

  window.addEventListener('message', function (event) {
    let item = event.data;

    if (item.action === 'sendNotification')
      notify(item.notifyType, item.type, item.title, item.message, item.time);

    if (item.action === 'removeAllHelpNotify') {
      $('.help-notify').each(function () {
        let id = $(this).attr('class').split(' ')[1].split('-')[2];
        $(this).css('animation', 'scaleOut 0.5s ease-in-out forwards');

        setTimeout(function () {
          $(`.helpnotify-id-${id}`).remove();
        }, 500);
      });
    }
  });
});
