local progressBars = {}

local isOpen = false
local startCoords

local function isBlacklisted(string)
    local blacklistedStrings = {
        '<', '>', '<video', '<img', '<script', 'http://', 'https://', '.png', '.jpg', '.jpeg'
    }

    for i = 1, #blacklistedStrings do
        if string.find(string, blacklistedStrings[i]) then
            return true
        end
    end

    return false
end


function Notify(typ, title, message, time)
    if isBlacklisted(message) then
        return
    end

    if isBlacklisted(title) then
        return
    end

    SendNUIMessage({
        action = 'sendNotification',
        notifyType = 'notify',
        type = typ,
        title = title,
        message = message,
        time = time or 5000
    })
end

function Announce(typ, message, time)
    if isBlacklisted(message) then
        return
    end

    SendNUIMessage({
        action = 'sendNotification',
        notifyType = 'announce',
        type = typ,
        message = message,
        time = time or 5000
    })
end

function Progressbar(message, time, callback)

    if isBlacklisted(message) then
        return
    end

    SendNUIMessage({
        action = 'sendNotification',
        notifyType = 'progressbar',
        message = "This is a test",
        time = 5000
    })
    Wait(time)
    callback()
end

function HelpNotify(message, title)

    if isOpen then  
        return
    end

    if isBlacklisted(message) then
        return
    end

    if isBlacklisted(title) then
        return
    end

    if not isOpen then
        SendNUIMessage({
            action = 'sendNotification',
            notifyType = 'help',
            message = message,
            title = title
        })
        isOpen = true
    end
end

function KillHelpNotifys()
    SendNUIMessage({
        action = 'removeAllHelpNotify',
        notifyType = 'help'
    })
    isOpen = false
end

exports('Notify', Notify)
exports('Announce', Announce)
exports('Progressbar', Progressbar)
exports('HelpNotify', HelpNotify)
exports('KillNotify', KillHelpNotifys)


RegisterCommand("notify", function()
    Notify("success", "Test", "This is a test", 5000)
    Notify("error", "Test", "This is a test", 5000)
    Notify("lifeinvader", "Test", "This is a test", 5000)
    Notify("police", "Test", "This is a test", 5000)
    Notify("medic", "Test", "This is a test", 5000)
    Notify("mechanic", "Test", "This is a test", 5000)
    Notify("teamchat", "Test", "This is a test", 5000)
end)

RegisterCommand("announce", function()
    Announce("information", "This is a test", 5000)
    Announce("admin", "This is a test", 5000)
    Announce("restart", "This is a test", 5000)
end)

RegisterCommand("progressbar", function()
    Progressbar("This is a test", 5000, function()
        print("Done")
    end)
end)
