--[[ Citizen.CreateThread(function()
    local scaleformHandle = RequestScaleformMovieInstance("GuideScaleform") -- The scaleform you want to use
    --print(scaleformHandle)
    while not HasScaleformMovieLoaded(scaleformHandle) do -- Ensure the scaleform is actually loaded before using
      print("Scaleform not loaded")
      Citizen.Wait(0)
    end
    print("Scaleform loaded")
    BeginScaleformMovieMethod(scaleformHandle, "SET_PLAYER_NAME") -- The function you want to call from the AS file
    PushScaleformMovieMethodParameterString("GoldO") -- bigTxt
    EndScaleformMovieMethod() -- Finish off the scaleform, it returns no data, so doesn't need "EndScaleformMovieMethodReturn"
    
    while true do -- Draw the scaleform every frame
      Citizen.Wait(0)
      DrawScaleformMovieFullscreen(scaleformHandle, 255, 255, 255, 255) -- Draw the scaleform fullscreen
    end
end) ]]

CreateThread(function()
  RegisterFontFile("gwibble")
  RegisterFontId("gwibble")
end)

RegisterCommand("TestScaleform", function()
  local scaleformHandle = LoadScale("menuscaleform")
  local hex = tostring(rgbToHex({255, 255, 0}))
  print(hex)
  BeginScaleformMovieMethod(scaleformHandle, "SET_PLAYER_NAME")
  --PushScaleformMovieMethodParameterString("GoldO")
  
  --PushScaleformMovieMethodParameterString("<FONT color='#FF0000'> GoldO2")
  PushScaleformMovieMethodParameterString("<FONT color='#".. hex .."' FACE='" .. "gwibble" .."'> GoldO4")
  --PushScaleformMovieMethodParameterString("<FONT color='#" .. rgbToHex({255, 255, 255}) .. "'>" .. "GoldO2")
  --"<FONT color='#" .. sprayData.color .. "' FACE='" .. sprayData.font .. "'>" .. sprayData.text
  EndScaleformMovieMethod()

  BeginScaleformMovieMethod(scaleformHandle, "SET_PLAYER_IMAGE")
  PushScaleformMovieMethodParameterString("iron")
  PushScaleformMovieMethodParameterString("menuscaleform.ytd")
  PushScaleformMovieMethodParameterString("graffitiImg")
  EndScaleformMovieMethod()

  while scaleformHandle do -- Draw the scaleform every frame
    Wait(0)
    DrawScaleformMovieFullscreen(scaleformHandle, 255, 255, 255, 255) -- Draw the scaleform fullscreen
  end
  --DrawScaleformMovieFullscreen(scaleformHandle, 255, 255, 255, 0)
end)

RegisterCommand("TestBuildInScaleform", function()
  local scaleformHandle = RequestScaleformMovie("mp_big_message_freemode") -- The scaleform you want to use
  while not HasScaleformMovieLoaded(scaleformHandle) do -- Ensure the scaleform is actually loaded before using
    Citizen.Wait(0)
  end

  BeginScaleformMovieMethod(scaleformHandle, "SHOW_SHARD_WASTED_MP_MESSAGE") -- The function you want to call from the AS file
  PushScaleformMovieMethodParameterString("Big Text") -- bigTxt
  PushScaleformMovieMethodParameterString("Smaller Text") -- msgText
  PushScaleformMovieMethodParameterInt(5) -- colId
  EndScaleformMovieMethod() -- Finish off the scaleform, it returns no data, so doesn't need "EndScaleformMovieMethodReturn"
  
  while true do -- Draw the scaleform every frame
    Citizen.Wait(0)
    DrawScaleformMovieFullscreen(scaleformHandle, 255, 255, 255, 255) -- Draw the scaleform fullscreen
  end
end)

function LoadScale(scalef)
	local handle = RequestScaleformMovie(scalef)
    while not HasScaleformMovieLoaded(handle) do
        Wait(0)
    end
    print("Scaleform loaded")
	return handle
end

function LoadScale2(scalef)
	local handle = RequestScaleformMovieInstance(scalef)
    while not HasScaleformMovieLoaded(handle) do
        Wait(0)
    end
    print("Scaleform loaded")
	return handle
end

function rgbToHex(rgb)
	local hexadecimal = ''

	for key, value in pairs(rgb) do
		local hex = ''

		while(value > 0)do
			local index = math.fmod(value, 16) + 1
			value = math.floor(value / 16)
			hex = string.sub('0123456789ABCDEF', index, index) .. hex			
		end

		if(string.len(hex) == 0)then
			hex = '00'

		elseif(string.len(hex) == 1)then
			hex = '0' .. hex
		end

		hexadecimal = hexadecimal .. hex
	end

	return hexadecimal
end

