Config = {}

-- =========================
-- PUMPKIN SPAWN LOCATIONS
-- =========================
Config.SpawnLocations = {
    {
        Pos = vector3(-1973.79, -1256.2, 108.43),
        BlipHash = -1258576797, -- Orange pumpkin blip
        BlipColor = "ORANGE"
    },
    {
        Pos = vector3(-3703.99, -3002.19, 2.84),
        BlipHash = -1258576797,
        BlipColor = "ORANGE"
    },
    {
        Pos = vector3(828.9, 2104.01, 279.14),
        BlipHash = -1258576797,
        BlipColor = "ORANGE"
    }
}

-- =========================
-- SPAWN / COLLECTION SETTINGS
-- =========================
Config.SpawnRadius = 20           -- radius around each spawn location
Config.TotalPumpkins = 5          -- total active pumpkins
Config.RespawnTime = 5            -- minutes before respawn
Config.CollectDistance = 2.0      -- distance to collect
Config.PumpkinModel = "p_pumpkin_02x"

-- =========================
-- REWARD SETTINGS
-- =========================
Config.RewardItem = "pumpkin"     -- VORP item name
Config.RewardAmount = 1           -- how many per collection
Config.PointsPerCollect = 1       -- leaderboard points per pumpkin
Config.LeaderboardTop = 20        -- top N players shown in leaderboard

-- =========================
-- MAP / BLIP SETTINGS
-- =========================
Config.Blip = true                -- enable/disable blips
Config.BlipScale = 0.2            -- default blip scale
Config.BlipColors = {
    LIGHT_BLUE    = 'BLIP_MODIFIER_MP_COLOR_1',
    DARK_RED      = 'BLIP_MODIFIER_MP_COLOR_2',
    PURPLE        = 'BLIP_MODIFIER_MP_COLOR_3',
    ORANGE        = 'BLIP_MODIFIER_MP_COLOR_4',
    TEAL          = 'BLIP_MODIFIER_MP_COLOR_5',
    LIGHT_YELLOW  = 'BLIP_MODIFIER_MP_COLOR_6',
    PINK          = 'BLIP_MODIFIER_MP_COLOR_7',
    GREEN         = 'BLIP_MODIFIER_MP_COLOR_8',
    WHITE         = 'BLIP_MODIFIER_MP_COLOR_32',
}

-- =========================
-- MARKER VISUAL SETTINGS
-- =========================
Config.MarkerScale = 2.0
Config.MarkerColor = { r = 255, g = 165, b = 0, a = 80 }




