const NUI_RES = (typeof GetParentResourceName === 'function') ? GetParentResourceName() : 'hitman';

const qs = (sel) => document.querySelector(sel);
const brief   = qs('#brief');
const tracker = qs('#tracker');
const trkStatus = qs('#trk-status');
const trkDist   = qs('#trk-dist');
const trkBar    = qs('#trk-bar');
const toast     = qs('#toast');

const chipRegion = qs('#chip-region');
const chipRadius = qs('#chip-radius');
const chipDiff   = qs('#chip-difficulty');
const intelEl    = qs('#brief-intel');

function post(name, data={}) {
  return fetch(`https://${NUI_RES}/${name}`, {
    method: 'POST',
    headers: { 'Content-Type': 'application/json; charset=UTF-8' },
    body: JSON.stringify(data)
  });
}

function showBrief(data) {
  chipRegion.textContent = data.region || 'San Andreas';
  chipRadius.textContent = `${Math.round(data.radius || 250)} m`;
  intelEl.textContent    = data.intel || 'Approach the marked area to reveal the target.';
  chipDiff.textContent   = (data.difficulty || 'Armed');

  brief.classList.remove('hidden');
}
function hideBrief(){ brief.classList.add('hidden'); }

function showTracker(){ tracker.classList.remove('hidden'); }
function hideTracker(){ tracker.classList.add('hidden'); }
function setTracker(status, distMeters, progress01, hideMetric){
  trkStatus.textContent = status || '...';

  if (hideMetric) {
    tracker.classList.add('no-metric');
    return;
  } else {
    tracker.classList.remove('no-metric');
  }

  trkDist.textContent = (distMeters != null) ? Math.max(0, Math.round(distMeters)) : '--';
  trkBar.style.width = `${Math.max(0, Math.min(100, Math.round((progress01 || 0)*100)))}%`;
}

function showToast(text) {
  toast.textContent = text;
  toast.classList.remove('hidden');
  setTimeout(() => toast.classList.add('hidden'), 2200);
}

window.addEventListener('message', (e) => {
  const { action, data } = e.data || {};
  if (!action) return;

  if (action === 'openBrief') showBrief(data || {});
  if (action === 'closeBrief') hideBrief();

  if (action === 'showTracker') showTracker();
  if (action === 'hideTracker') hideTracker();
  if (action === 'updateTracker') setTracker(data?.status, data?.distance, data?.progress, data?.hideMetric);

  if (action === 'toast') showToast(data?.text || '');
});

qs('#accept').addEventListener('click', () => post('accept', {}).then(hideBrief));
qs('#decline').addEventListener('click', () => post('decline', {}).then(hideBrief));

window.addEventListener('keydown', (ev) => {
  if (brief.classList.contains('hidden')) return;
  if (ev.key === 'Enter')     { post('accept', {}).then(hideBrief); }
  if (ev.key === 'Backspace') { post('decline', {}).then(hideBrief); }
  if (ev.key === 'Escape')    { post('decline', {}).then(hideBrief); }
});
