local ESX = nil
if Config.Framework and Config.Framework.type == 'esx' and GetResourceState('es_extended') == 'started' then
    if exports['es_extended'] and exports['es_extended'].getSharedObject then
        ESX = exports['es_extended']:getSharedObject()
    else
        pcall(function() TriggerEvent('esx:getSharedObject', function(obj) ESX = obj end) end)
    end
end

ActiveContracts = ActiveContracts or {}
Cooldowns       = Cooldowns or {}
Config.CooldownSeconds = Config.CooldownSeconds or 300

-- ===== Helpers =====
local function getIdentifier(src)
  for _, id in ipairs(GetPlayerIdentifiers(src)) do
    if id:find('license:') then return id end
  end
  return ('temp:%s'):format(src)
end

local function usingESX()
    return Config.Framework and Config.Framework.type == 'esx' and ESX ~= nil
end

local function canRequestServer(src)
  if ActiveContracts[src] then
    return { ok = false, reason = 'active', left = 0 }
  end
  local ident = getIdentifier(src)
  local cd = tonumber(Config.CooldownSeconds or 300)
  local last = Cooldowns[ident]
  if last then
    local left = cd - (os.time() - last)
    if left > 0 then
      return { ok = false, reason = 'cooldown', left = left }
    end
  end
  return { ok = true }
end

lib.callback.register('hitman:server:canRequest', function(source)
  return canRequestServer(source)
end)

local function giveReward(src)
    if usingESX() then
        local xPlayer = ESX.GetPlayerFromId(src)
        if not xPlayer then return end

        local cash = tonumber(Config.Framework.rewardCash or 0)
        local account = Config.Framework.rewardAccount
        local gotSomething = false
        local msgParts = {}

        if cash and cash > 0 then
            if account and account ~= '' and account ~= 'cash' then
                xPlayer.addAccountMoney(account, cash)
                table.insert(msgParts, ('%s $%s'):format(account, cash))
            else
                xPlayer.addMoney(cash)
                table.insert(msgParts, ('$%s cash'):format(cash))
            end
            gotSomething = true
        end

        if gotSomething then
            xPlayer.showNotification('~g~Funds transferred:~s~ ' .. table.concat(msgParts, ', '))
        end
    else
        TriggerClientEvent('ox_lib:notify', src, {
            title = 'Contract Complete',
            description = 'Target eliminated.',
            type = 'success'
        })
    end
end


local function applyFailPenalty(src)
  if usingESX() and (Config.Framework.failPenaltyCash or 0) > 0 then
    local xPlayer = ESX.GetPlayerFromId(src)
    if xPlayer then xPlayer.removeMoney(Config.Framework.failPenaltyCash) end
  end
end

-- ===== Events =====
RegisterNetEvent('hitman:server:requestContract', function()
  local src = source
  local gate = canRequestServer(src)
  if not gate.ok then
    local msg = (gate.reason == 'active') and 'You already have an active contract.'
              or ('You are on cooldown ('..math.max(0, gate.left)..'s).')
    TriggerClientEvent('hitman:client:notify', src, { description = msg, type = 'error' })
    return
  end
  TriggerClientEvent('hitman:client:brief', src, { intel = 'Target profile loaded.' })
end)

RegisterNetEvent('hitman:server:acceptContract', function()
  local src = source
  local gate = canRequestServer(src)
  if not gate.ok then
    local msg = (gate.reason == 'active') and 'You already have an active contract.'
              or ('You are on cooldown ('..math.max(0, gate.left)..'s).')
    TriggerClientEvent('hitman:client:notify', src, { description = msg, type = 'error' })
    return
  end

  ActiveContracts[src] = true
  TriggerClientEvent('hitman:client:begin', src)
end)

RegisterNetEvent('hitman:server:decline', function()
  local src = source
  if ActiveContracts[src] then ActiveContracts[src] = nil end
end)


RegisterNetEvent('hitman:server:complete', function(headshot)
  local src = source
  local ident = getIdentifier(src)
  
  if ActiveContracts[src] then ActiveContracts[src] = nil end
  Cooldowns[ident] = os.time()

  if usingESX() then

    giveReward(src)

    TriggerClientEvent('hitman:client:notify', src, {
      description = headshot and 'Contract complete (Headshot).' or 'Contract complete.',
      type = 'success'
    })

  else

    TriggerClientEvent('ox_lib:notify', src, {
      title = 'Contract Complete',
      description = headshot and 'Target eliminated (Headshot).' or 'Target eliminated.',
      type = 'success'
    })

  end

end)

RegisterNetEvent('hitman:server:fail', function(reason, applyCooldown)
  local src = source
  local ident = getIdentifier(src)
  if ActiveContracts[src] then ActiveContracts[src] = nil end
  if applyCooldown then Cooldowns[ident] = os.time() end

  applyFailPenalty(src)

  TriggerClientEvent('hitman:client:notify', src, {
    description = reason or 'Contract failed.',
    type = 'error'
  })
end)

AddEventHandler('playerDropped', function()
  local src = source
  if ActiveContracts[src] then ActiveContracts[src] = nil end
end)
