-- General Config
Config = {
  CooldownSeconds = 600,
  ContractRadius = { min = 200.0, max = 1000.0 },
  TargetModels = { `a_m_m_business_01`, `a_m_m_eastsa_01`, `a_m_m_skater_01` },
  TargetArmed = true,
  TargetWeapon = `WEAPON_MICROSMG`,
  TargetAmmo = 120,
  Blip = { sprite = 458, color = 1, scale = 0.8, name = 'Contract Target' }
}

Config.Waypoint = { 
  enabled = true -- Draw waypoint towards search area
} 

-- Framework settings
Config.Framework = {
  type = 'standalone',        -- 'esx' | 'standalone'
  rewardCash = 5000, 
  rewardAccount = bank, -- e.g. 'bank' if you prefer bank payouts; nil to skip
  rewardCount = 1,
  failPenaltyCash = 0
}

Config.Combat = {
  Accuracy = 90,
  CombatRange = 3,  -- 0=Near, 1=Medium, 2=Far, 3=Very Far
  CombatMovement = 1,  -- 0=Stationary,1=Defensive,2=Offensive,3=Suicidal
  HearingRange = 75.0,
  SeeingRange = 95.0,
  ReactDistance = 105.0,
  ReactToShotDistance = 150.0
}

Config.Hints = {
  enabled = true, -- Briefly flash the target location every so often when enabled
  interval = 15, -- seconds between flashes
  durationMs = 1800,
}

Config.MapCircle = {
  radius = 350.0,
  offset = { min = 80.0, max = 180.0 },
  color = 47,
  alpha = 120
}

Config.Broker = {
  enabled = true,
  spawnDistance = 80.0,
  interactDistance = 2.2, 
  useBlips = true,
  debug = false -- draw a marker ring when nearby
}

Config.Brokers = {
  {
    label = 'Fixer (Del Perro Pier)',
    coords = vec3(-1591.6, -1008.8, 13.0), heading = 140.0,
    model = `ig_vincent`, scenario = 'WORLD_HUMAN_STAND_MOBILE',
    blip = { sprite = 280, color = 1, scale = 0.8, name = 'Fixer' }
  },
  {
    label = 'Fixer (Mission Row)',
    coords = vec3(448.7, -930.9, 28.7), heading = 227.0,
    model = `ig_mrk`, scenario = 'WORLD_HUMAN_SMOKING',
    blip = { sprite = 280, color = 1, scale = 0.8, name = 'Fixer' }
  },
  {
    label = 'Fixer (Sandy Shores)',
    coords = vec3(1739.4, 3709.7, 34.1), heading = 15.0,
    model = `ig_claypain`, scenario = 'WORLD_HUMAN_SMOKING',
    blip = { sprite = 280, color = 1, scale = 0.8, name = 'Fixer' }
  },
  {
    label = 'Fixer (Paleto Bay)',
    coords = vec3(-133.3, 6351.8, 31.5), heading = 220.0,
    model = `ig_chengsr`, scenario = 'WORLD_HUMAN_AA_COFFEE',
    blip = { sprite = 280, color = 1, scale = 0.8, name = 'Fixer' }
  },
}

Config.Broker.Dialogue = {
  openers = {
    "You look like you can handle yourself.",
    "Right on time.",
    "Got something that needs doing.",
    "Quiet job. Discrete pay."
  },
  pitches = {
    "Client wants a problem solved—fast. You in?",
    "Target’s been sloppy. Someone wants it cleaned up.",
    "Got a name and an area. Keep it tidy."
  },
  busy = {
    "You’re hot right now. Give it ~t.",
    "No go. Client wants you to cool off ~t.",
    "Stand down. Try again in ~t."
  },
  intel = {
    "Neighborhood eyes are jumpy—keep it low.",
    "Target moves. Don’t stand still.",
    "Area’s noisy; stay alert."
  },
  labels = {
    rootTitle   = "FIXER",
    accept      = "I’m looking for work",
    intel       = "Got any intel?",
    back        = "Nevermind",
    busyTitle   = "BUSY",
    busyOk      = "Alright",
  }
}

Config.WorldSpawn = {
  enabled = true,
  minDistanceFromPlayer = 800.0,
  maxAttempts = 25,
  bounds = { minX = -4300.0, maxX = 4500.0, minY = -4800.0, maxY = 4800.0 },
  requireInCircle = true,
  lingerMs = 1800,
  triggerDist = 220.0
}

Config.TargetMode = 'vehicle'  -- 'vehicle' or 'onfoot'

Config.Vehicle = {
  models = { `tailgater`, `oracle`, `sultan`, `stanier`, `fugitive`, `premier` },
  speed = 67.0,
  drivingStyle = 786603,
  keepEngineOn = true
}

Config.Blacklist = {
  enabled = true,
  debug = false,

  circles = {
    -- Fort Zancudo
    { center = vec3(-2048.0, 3130.0, 30.0), radius = 900.0, label = 'Fort Zancudo' },
    -- Prison
    { center = vec3(1845.0, 2585.0, 40.0), radius = 350.0, label = 'Bolingbroke Prison' },
  },

  boxes = {
    -- Example: Zancudo runway band (approx—adjust to taste)
    { center = vec3(-2300.0, 3250.0, 30.0), length = 2000.0, width = 500.0, heading = 50.0, minZ = -10.0, maxZ = 120.0, label = 'Zancudo Runways' },
    -- Example: Prison rectangular keep-out (approx)
    { center = vec3(1690.0, 2590.0, 45.0), length = 900.0, width = 700.0, heading = 0.0, minZ = 20.0, maxZ = 120.0, label = 'Prison Block' },
  }
}

Config.RevealDistance = 65.0
Config.RevealOnGunshot = false