local autoWaypoint = Config.Waypoint and Config.Waypoint.enabled ~= false
local lastHintPulse = 0
local revealedExact = false
local nui, setFocus
do
  nui = function(action, data)
    SendNUIMessage({ action = action, data = data })
  end

  setFocus = function(enable)
    SetNuiFocus(enable, enable)
    SetNuiFocusKeepInput(false)
  end
end

local contract = false
local engaged = false

local vehicle = nil
local targetPed = nil
local targetBlip = nil
local areaBlip = nil

local hintCenter = nil
local spawnPos, spawnHdg = nil, 0.0
local prePlan = { pos = nil, hdg = 0.0, hint = nil, region = nil }

local hitmanTargetGroup = 0

local spawnReadySince = 0

local function notify(opts)
  lib.notify({
    title = 'Hitman',
    description = opts.description or '',
    type = opts.type or 'inform',
    position = 'top-right',
    duration = 5000
  })
end
RegisterNetEvent('hitman:client:notify', notify)

local function playMissionIntro(title, subtitle, durationMs)
  title = title or 'CONTRACT STARTED'
  subtitle = subtitle or 'Eliminate the target'
  durationMs = durationMs or 3200

  local sf = RequestScaleformMovie('MP_BIG_MESSAGE_FREEMODE')
  while not HasScaleformMovieLoaded(sf) do Wait(0) end

  BeginScaleformMovieMethod(sf, 'SHOW_SHARD_CENTERED_MP_MESSAGE')
  PushScaleformMovieMethodParameterString(title)
  PushScaleformMovieMethodParameterString(subtitle)
  EndScaleformMovieMethod()

  StartScreenEffect('MinigameTransitionIn', 0, true)
  PlaySoundFrontend(-1, 'PROPERTY_PURCHASE', 'HUD_AWARDS', true)

  local endAt = GetGameTimer() + durationMs
  local barH = 0.27
  local fadeIn = 220
  local fadeOut = 260

  while GetGameTimer() < endAt do
    Wait(0)
    local t = endAt - GetGameTimer()
    local a = 200
    if GetGameTimer() - (endAt - durationMs) < fadeIn then
      local k = (GetGameTimer() - (endAt - durationMs)) / fadeIn
      a = math.floor(200 * math.max(0.0, math.min(1.0, k)))
    elseif t < fadeOut then
      local k = t / fadeOut
      a = math.floor(200 * math.max(0.0, math.min(1.0, k)))
    end
    DrawScaleformMovieFullscreen(sf, 255, 255, 255, 255, 0)
  end

  StartScreenEffect('MinigameTransitionOut', 0, false)
  StopScreenEffect('MinigameTransitionIn')
  SetScaleformMovieAsNoLongerNeeded(sf)
end

local function setWaypointToHint()
  if not autoWaypoint or not hintCenter then return end
  SetNewWaypoint(hintCenter.x + 0.0, hintCenter.y + 0.0)
end

local function clearWaypoint()
  SetWaypointOff()
end

local function setFocus(enable)
  SetNuiFocus(enable, enable)
  SetNuiFocusKeepInput(false)
end

local function nui(action, data)
  SendNUIMessage({ action = action, data = data })
end

local function placeOnGround(ent)
  if type(PlaceEntityOnGroundProperly) == 'function' then
    PlaceEntityOnGroundProperly(ent)
  else
    Citizen.InvokeNative(0x58A850EAEE20FAA3, ent)
  end
end

local function streamInAt(pos, radius, timeoutMs)
  radius = radius or 140.0
  timeoutMs = timeoutMs or 3000
  NewLoadSceneStartSphere(pos.x, pos.y, pos.z, radius, 0)
  local t = GetGameTimer()
  while not IsNewLoadSceneLoaded() and (GetGameTimer() - t) < timeoutMs do
    Wait(0)
  end
  NewLoadSceneStop()
  SetFocusPosAndVel(pos.x, pos.y, pos.z, 0.0, 0.0, 0.0)
  RequestCollisionAtCoord(pos.x, pos.y, pos.z)
  for i = 1, 30 do Wait(0) end
end

local function createAreaBlip(center, radius)
  if DoesBlipExist(areaBlip) then RemoveBlip(areaBlip) end
  areaBlip = AddBlipForRadius(center.x + 0.0, center.y + 0.0, center.z + 0.0, radius + 0.0)
  SetBlipColour(areaBlip, (Config.MapCircle and Config.MapCircle.color) or 5)
  SetBlipAlpha(areaBlip, (Config.MapCircle and Config.MapCircle.alpha) or 130)
  SetBlipAsShortRange(areaBlip, false)
end

local function revealExactBlip()
  if DoesBlipExist(areaBlip) then RemoveBlip(areaBlip) end
  local entity = targetPed
  if not entity or not DoesEntityExist(entity) then return end

  revealedExact = true

  if DoesBlipExist(targetBlip) then return end
  targetBlip = AddBlipForEntity(entity)
  SetBlipSprite(targetBlip, (Config.Blip and Config.Blip.sprite) or 225)
  SetBlipColour(targetBlip, (Config.Blip and Config.Blip.color) or 1)
  SetBlipScale(targetBlip, (Config.Blip and Config.Blip.scale) or 0.9)
  BeginTextCommandSetBlipName('STRING')
  AddTextComponentString((Config.Blip and Config.Blip.name) or 'Contract Target')
  EndTextCommandSetBlipName(targetBlip)
end

local function ensureRelationshipGroups()
  if hitmanTargetGroup ~= 0 then return end
  local _, grp = AddRelationshipGroup('HITMAN_TARGET')
  hitmanTargetGroup = grp
  local playerGrp = GetHashKey('PLAYER')
  SetRelationshipBetweenGroups(5, hitmanTargetGroup, playerGrp)
  SetRelationshipBetweenGroups(5, playerGrp, hitmanTargetGroup)
end

local function tuneCombatStats(ped)
  local C = Config.Combat or {}
  SetPedAccuracy(ped, C.Accuracy or 35)
  SetPedSeeingRange(ped, C.SeeingRange or 65.0)
  SetPedHearingRange(ped, C.HearingRange or 45.0)
  SetPedCombatRange(ped, C.CombatRange or 2)
  SetPedCombatMovement(ped, C.CombatMovement or 2)
  SetPedAlertness(ped, 2)
  SetPedArmour(ped, 0)
  SetPedSuffersCriticalHits(ped, true)
  SetPedCombatAttributes(ped, 5, true)
  SetPedCombatAttributes(ped, 46, true)
  SetPedCombatAttributes(ped, 0, true)
  SetPedCombatAttributes(ped, 2, true)
  SetPedCanSwitchWeapon(ped, true)
  SetPedFleeAttributes(ped, 0, false)
end

local function startAggro()
  if not targetPed or not DoesEntityExist(targetPed) or engaged then return end
  engaged = true
  local me = PlayerPedId()
  if vehicle and DoesEntityExist(vehicle) and GetPedInVehicleSeat(vehicle, -1) == targetPed then
    TaskVehicleChase(targetPed, me)  
    SetDriveTaskDrivingStyle(targetPed, 786603)
  else
    ClearPedTasksImmediately(targetPed)
    TaskCombatPed(targetPed, me, 0, 16)
  end
  SetPedKeepTask(targetPed, true)
end

local function deg2rad(d) return d * 0.017453292519943295 end
local function inCircle(pos, z)
  if not z or not z.center or not z.radius then return false end
  local dx, dy = pos.x - z.center.x, pos.y - z.center.y
  if z.minZ and pos.z < z.minZ then return false end
  if z.maxZ and pos.z > z.maxZ then return false end
  return (dx*dx + dy*dy) <= (z.radius * z.radius)
end
local function inBox(pos, z)
  if not z or not z.center or not z.length or not z.width then return false end
  local dx, dy = pos.x - z.center.x, pos.y - z.center.y
  local h = deg2rad(z.heading or 0.0)
  local cosH, sinH = math.cos(-h), math.sin(-h)
  local lx = dx * cosH - dy * sinH
  local ly = dx * sinH + dy * cosH
  if z.minZ and pos.z < z.minZ then return false end
  if z.maxZ and pos.z > z.maxZ then return false end
  return math.abs(lx) <= (z.length * 0.5) and math.abs(ly) <= (z.width * 0.5)
end
local function isBlacklisted(pos)
  local bl = Config.Blacklist
  if not bl or not bl.enabled then return false end
  if bl.circles then
    for i = 1, #bl.circles do
      if inCircle(pos, bl.circles[i]) then return true end
    end
  end
  if bl.boxes then
    for i = 1, #bl.boxes do
      if inBox(pos, bl.boxes[i]) then return true end
    end
  end
  return false
end

local function randomXYInBounds()
  local b = (Config.WorldSpawn and Config.WorldSpawn.bounds) or { minX=-4300.0, maxX=4500.0, minY=-4800.0, maxY=4800.0 }
  return b.minX + math.random()*(b.maxX-b.minX), b.minY + math.random()*(b.maxY-b.minY)
end

local function findGlobalRoadSpawn()
  local me = PlayerPedId()
  local myPos = GetEntityCoords(me)
  local maxAttempts = (Config.WorldSpawn and Config.WorldSpawn.maxAttempts) or 25
  local minDist = (Config.WorldSpawn and Config.WorldSpawn.minDistanceFromPlayer) or 800.0

  for i = 1, maxAttempts do
    local rx, ry = randomXYInBounds()
    local ok, nodePos, hdg = GetClosestVehicleNodeWithHeading(rx, ry, 50.0, 1, 3.0, 0)
    local pos = ok and nodePos or vec3(rx, ry, 50.0)

    local _ = 0.0
    if not GetWaterHeightNoWaves(pos.x, pos.y, pos.z, _) then
      local okz, gz = GetGroundZFor_3dCoord(pos.x, pos.y, pos.z + 50.0, false)
      if okz then pos = vec3(pos.x, pos.y, gz) end

      if not isBlacklisted(pos) and #(pos - myPos) >= minDist then
        return pos, (hdg or math.random()*360.0)
      end
    end
    Wait(0)
  end

  return GetEntityCoords(me) + vector3(300.0, 0.0, 0.0), math.random()*360.0
end

local function prepareTargetSite()
  ensureRelationshipGroups()

  local pos, hdg
  if Config.WorldSpawn and Config.WorldSpawn.enabled ~= false then
    pos, hdg = findGlobalRoadSpawn()
  else
    local p = GetEntityCoords(PlayerPedId())
    local ok, nodePos, h = GetClosestVehicleNodeWithHeading(p.x + 250.0, p.y, p.z, 1, 3.0, 0)
    pos, hdg = (ok and nodePos or p + vector3(250.0,0.0,0.0)), (h or math.random()*360.0)
  end

  spawnPos, spawnHdg = pos, hdg

  local H = Config.MapCircle or {}
  local oxMin, oxMax = (H.offset and H.offset.min) or 80.0, (H.offset and H.offset.max) or 180.0
  local a = math.random() * math.pi * 2
  local r = oxMin + math.random()*(oxMax-oxMin)
  hintCenter = vec3(pos.x + math.cos(a)*r, pos.y + math.sin(a)*r, pos.z)

  if isBlacklisted(hintCenter) then
    for _ = 1, 6 do
      a = math.random() * math.pi * 2
      r = oxMin + math.random()*(oxMax-oxMin)
      local try = vec3(pos.x + math.cos(a)*r, pos.y + math.sin(a)*r, pos.z)
      if not isBlacklisted(try) then hintCenter = try; break end
      Wait(0)
    end
  end

  createAreaBlip(hintCenter, H.radius or 250.0)
  engaged = false
end

local function spawnDrivingTarget()
  if not spawnPos or vehicle or targetPed then return end

  streamInAt(spawnPos, 140.0, 3000)

  local V = Config.Vehicle or {}
  local vModels = V.models or { `tailgater`, `oracle`, `sultan`, `stanier`, `fugitive`, `premier` }
  local vModel = vModels[math.random(#vModels)]
  lib.requestModel(vModel, 10000)
  vehicle = CreateVehicle(vModel, spawnPos.x, spawnPos.y, spawnPos.z + 1.0, spawnHdg, true, true)
  SetVehicleOnGroundProperly(vehicle)
  SetEntityAsMissionEntity(vehicle, true, true)
  SetVehicleDoorsLocked(vehicle, 1)
  if V.keepEngineOn ~= false then SetVehicleEngineOn(vehicle, true, true, false) end

  local pModels = Config.TargetModels or { `a_m_m_business_01`, `a_m_m_eastsa_01`, `a_m_m_skater_01` }
  local pModel = pModels[math.random(#pModels)]
  lib.requestModel(pModel, 8000)
  targetPed = CreatePed(4, pModel, spawnPos.x, spawnPos.y, spawnPos.z + 1.0, spawnHdg, true, true)
  SetEntityAsMissionEntity(targetPed, true, true)
  SetPedIntoVehicle(targetPed, vehicle, -1)

  if Config.TargetArmed then
    GiveWeaponToPed(targetPed, Config.TargetWeapon or `WEAPON_PISTOL`, Config.TargetAmmo or 120, false, true)
    SetCurrentPedWeapon(targetPed, Config.TargetWeapon or `WEAPON_PISTOL`, true)
  end
  SetPedRelationshipGroupHash(targetPed, hitmanTargetGroup)
  tuneCombatStats(targetPed)

  local speed = (V.speed or 17.0)
  local style = (V.drivingStyle or 786603)
  TaskVehicleDriveWander(targetPed, vehicle, speed, style)
  SetPedKeepTask(targetPed, true)

  placeOnGround(vehicle)
  placeOnGround(targetPed)
  ClearFocus()
end

local function cleanupTarget()
  if DoesBlipExist(targetBlip) then RemoveBlip(targetBlip) end
  if DoesBlipExist(areaBlip) then RemoveBlip(areaBlip) end
  targetBlip, areaBlip, hintCenter = nil, nil, nil

  if vehicle and DoesEntityExist(vehicle) then DeleteEntity(vehicle) end
  if targetPed and DoesEntityExist(targetPed) then DeleteEntity(targetPed) end
  vehicle, targetPed = nil, nil

  spawnPos, spawnHdg = nil, 0.0
  spawnReadySince = 0
  prePlan = { pos = nil, hdg = 0.0, hint = nil, region = nil }
  clearWaypoint()
  lastHintPulse = 0
  revealedExact = false

end

local function planSiteForBrief()
  local pos, hdg = findGlobalRoadSpawn()

  local H = Config.MapCircle or {}
  local oxMin, oxMax = (H.offset and H.offset.min) or 80.0, (H.offset and H.offset.max) or 180.0
  local a = math.random() * math.pi * 2
  local r = oxMin + math.random() * (oxMax - oxMin)
  local hint = vec3(pos.x + math.cos(a) * r, pos.y + math.sin(a) * r, pos.z)

  if isBlacklisted and isBlacklisted(hint) then
    for _ = 1, 6 do
      a = math.random() * math.pi * 2
      r = oxMin + math.random() * (oxMax - oxMin)
      local try = vec3(pos.x + math.cos(a) * r, pos.y + math.sin(a) * r, pos.z)
      if not isBlacklisted(try) then hint = try; break end
      Wait(0)
    end
  end

  local zone = GetNameOfZone(hint.x, hint.y, hint.z)
  local region = zone and GetLabelText(zone) or 'San Andreas'

  prePlan.pos, prePlan.hdg, prePlan.hint, prePlan.region = pos, hdg, hint, region
end

RegisterNetEvent('hitman:client:brief', function(payload)
  planSiteForBrief()

  setFocus(true)
  nui('openBrief', {
    region = prePlan.region or 'San Andreas',
    radius = (Config.MapCircle and Config.MapCircle.radius) or 250,
    intel  = (payload and payload.intel) or 'Approach the marked area to reveal the target.',
    difficulty = 'Armed'
  })
end)

RegisterNUICallback('accept', function(_, cb)
  cb({ ok = true })
  setFocus(false)
  TriggerServerEvent('hitman:server:acceptContract')
end)

RegisterNUICallback('decline', function(_, cb)
  cb({ ok = true })
  setFocus(false)
  TriggerServerEvent('hitman:server:decline')
end)

RegisterNetEvent('hitman:client:begin', function()
  if contract then return end
  contract = true
  ensureRelationshipGroups()

  if prePlan.pos then
    spawnPos, spawnHdg = prePlan.pos, prePlan.hdg
    hintCenter = prePlan.hint
    createAreaBlip(hintCenter, (Config.MapCircle and Config.MapCircle.radius) or 250.0)
  else
    prepareTargetSite()
  end

  CreateThread(function()
    playMissionIntro('CONTRACT STARTED', 'Eliminate the target', 3200)
  end)

  notify({ description = 'Contract started. Search the marked area.' })
  setWaypointToHint()
end)

local prePlan = { pos = nil, hdg = 0.0, hint = nil, region = nil, distance = nil }

RegisterNetEvent('hitman:client:setPrePlan', function(plan)
  if not plan or not plan.pos or not plan.hint then return end
  prePlan.pos = plan.pos
  prePlan.hdg = plan.hdg or 0.0
  prePlan.hint = plan.hint
  prePlan.region = plan.region or 'San Andreas'
  prePlan.distance = plan.distance
end)

-- Loops
CreateThread(function()
  while true do
    Wait(200)
    if contract and spawnPos and not targetPed then
      local me = PlayerPedId()
      local mePos = GetEntityCoords(me)
      local inCircle = false
      local cond = false

      if (Config.WorldSpawn and Config.WorldSpawn.enabled and Config.WorldSpawn.requireInCircle) and hintCenter then
        local r = (Config.MapCircle and Config.MapCircle.radius) or 250.0
        inCircle = (#(mePos - hintCenter) <= r)
        cond = inCircle
      else
        if hintCenter then
          local trig = (Config.WorldSpawn and Config.WorldSpawn.triggerDist) or 220.0
          cond = (#(mePos - hintCenter) <= trig)
        else
          local trig = (Config.WorldSpawn and Config.WorldSpawn.triggerDist) or 220.0
          cond = (#(mePos - spawnPos) <= trig)
        end
      end

      if cond and Config.WorldSpawn and Config.WorldSpawn.requireOnFoot then
        cond = (not IsPedInAnyVehicle(me, false))
      end

      if cond then
        if spawnReadySince == 0 then spawnReadySince = GetGameTimer() end
        if (GetGameTimer() - spawnReadySince) >= ((Config.WorldSpawn and Config.WorldSpawn.lingerMs) or 1800) then
          spawnReadySince = 0
          spawnDrivingTarget()
        end
      else
        spawnReadySince = 0
      end
    else
      Wait(350)
    end
  end
end)

CreateThread(function()
  while true do
    Wait(200)
    if contract then
      local entity = targetPed
      if entity and DoesEntityExist(entity) then
        local me = PlayerPedId()
        local dist = #(GetEntityCoords(me) - GetEntityCoords(entity))
        if dist <= ((Config.RevealDistance) or 65.0) then
          revealExactBlip()
        end
      end
    else
      if DoesBlipExist(areaBlip) then RemoveBlip(areaBlip) end
      areaBlip = nil; hintCenter = nil
    end
  end
end)

CreateThread(function()
  while true do
    Wait(100)
    if contract and targetPed and DoesEntityExist(targetPed) then
      local me = PlayerPedId()
      local myPos = GetEntityCoords(me)
      local tgtPos = GetEntityCoords(targetPed)
      local dist = #(myPos - tgtPos)

      local C = Config.Combat or {}
      local aimingAt = IsPlayerFreeAiming(PlayerId()) and IsPlayerFreeAimingAtEntity(PlayerId(), targetPed) and dist <= (C.ReactDistance or 55.0)
      local shotNear = IsPedShooting(me) and dist <= (C.ReactToShotDistance or 80.0)
      local damaged = HasEntityBeenDamagedByEntity(targetPed, me, true)

      if aimingAt or shotNear or damaged then
        startAggro()
      end
    end
  end
end)

CreateThread(function()
  while true do
    Wait(200)
    if contract and targetPed and DoesEntityExist(targetPed) then
      if IsPedDeadOrDying(targetPed, true) then
        local _, bone = GetPedLastDamageBone(targetPed)
        local headshot = (bone == 31086 or bone == 39317)
        TriggerServerEvent('hitman:server:complete', headshot)

        cleanupTarget()
      playMissionIntro('CONTRACT COMPLETED', 'Target Eliminated', 3200)
        nui('hideTracker')
        contract, engaged = false, false
      end
    end
  end
end)

CreateThread(function()
  while true do
    Wait(120)
    if contract then
      local me = PlayerPedId()
      if IsPedDeadOrDying(me, true) then
        local killedByTarget = false
        local killer = GetPedSourceOfDeath(me)
        if killer and killer ~= 0 then
          if targetPed and DoesEntityExist(targetPed) and killer == targetPed then
            killedByTarget = true
          elseif vehicle and DoesEntityExist(vehicle) and killer == vehicle then
            killedByTarget = true
          end
        end

        if not killedByTarget then
          if targetPed and HasEntityBeenDamagedByEntity(me, targetPed, true) then
            killedByTarget = true
          elseif vehicle and HasEntityBeenDamagedByEntity(me, vehicle, true) then
            killedByTarget = true
          end
        end

        if killedByTarget then
          TriggerServerEvent('hitman:server:fail', 'You were eliminated by the target.', true)
          cleanupTarget()
          nui('hideTracker')
          contract, engaged = false, false
          Wait(1500)
        end
      end
    end
  end
end)

-- Debug
CreateThread(function()
  while true do
    local bl = Config.Blacklist
    if bl and bl.enabled and bl.debug then
      Wait(0)
      local me = PlayerPedId()
      local myPos = GetEntityCoords(me)
      if bl.circles then
        for i = 1, #bl.circles do
          local z = bl.circles[i]
          if #(myPos - z.center) < 2000.0 then
            DrawMarker(1, z.center.x, z.center.y, z.center.z - 1.0, 0.0,0.0,0.0, 0.0,0.0,0.0,
                       z.radius*2.0, z.radius*2.0, 2.0, 200,0,0, 60, false,false,2, false,nil,nil,false)
          end
        end
      end
      if bl.boxes then
        for i = 1, #bl.boxes do
          local z = bl.boxes[i]
          if #(myPos - z.center) < 2000.0 then
            DrawMarker(1, z.center.x, z.center.y, (z.center.z or 30.0) - 1.0, 0.0,0.0,0.0, 0.0,0.0,(z.heading or 0.0),
                       z.length, z.width, 2.0, 0,0,200, 60, false,false,2, false,nil,nil,false)
          end
        end
      end
    else
      Wait(400)
    end
  end
end)

-- HUD
CreateThread(function()
  while true do
    Wait(400)
    if contract then
      local entity = targetPed
      if entity and DoesEntityExist(entity) then
        local me = PlayerPedId()
        local dist = #(GetEntityCoords(me) - GetEntityCoords(entity))
        local revealed = DoesBlipExist(targetBlip)
        local revealDist = Config.RevealDistance or 65.0
        local status = revealed and 'Target revealed' or (entity and 'Close on the target' or 'Travel to search area')
        local progress
        if not revealed then
          local maxd = math.max(revealDist * 3.0, 1.0)
          progress = math.max(0.0, math.min(1.0, 1.0 - (dist - revealDist) / (maxd - revealDist)))
        else
          progress = 1.0
        end
        nui('updateTracker', { status = status, distance = dist, progress = progress })
      end
    else
      Wait(600)
    end
  end
end)

CreateThread(function()
  while true do
    Wait(500)
    if contract and Config.Hints and Config.Hints.enabled then
      local entity = vehicle or targetPed
      if entity and DoesEntityExist(entity) then
        local now = GetGameTimer()
        local intervalMs = (Config.Hints.interval or 30) * 1000
        if now - (lastHintPulse or 0) >= intervalMs then
          lastHintPulse = now

          if revealedExact and targetBlip and DoesBlipExist(targetBlip) then
            PulseBlip(targetBlip)
          else
            local temp = AddBlipForEntity(entity)
            SetBlipSprite(temp, (Config.Blip and Config.Blip.sprite) or 225)
            SetBlipColour(temp, (Config.Blip and Config.Blip.color) or 1)
            SetBlipScale(temp, (Config.Blip and Config.Blip.scale) or 0.9)
            SetBlipAsShortRange(temp, false)
            BeginTextCommandSetBlipName('STRING')
            AddTextComponentString((Config.Blip and Config.Blip.name) or 'Contract Target')
            EndTextCommandSetBlipName(temp)

            PulseBlip(temp)
            SetTimeout((Config.Hints.durationMs or 1800), function()
              if not revealedExact and DoesBlipExist(temp) then
                RemoveBlip(temp)
              end
            end)
          end
        end
      end
    else
      Wait(800)
    end
  end
end)

-- Commands
RegisterCommand('contract', function()
  if contract then
    notify({ description = 'You already have a contract.', type = 'error' })
  else
    TriggerServerEvent('hitman:server:requestContract')
  end
end, false)

RegisterCommand('cancelcontract', function()
  if contract then
    TriggerServerEvent('hitman:server:fail', 'Contract canceled.')
    cleanupTarget()
    nui('hideTracker')
    contract, engaged = false, false
  else
    notify({ description = 'No active contract.', type = 'inform' })
  end
end, false)

RegisterCommand('foaf', function()
      playMissionIntro('CONTRACT COMPLETED', 'Target Eliminated', 3200)
    TriggerServerEvent('hitman:server:complete')
end, false)

AddEventHandler('onResourceStop', function(res)
  if res ~= GetCurrentResourceName() then return end
  if DoesBlipExist(targetBlip) then RemoveBlip(targetBlip) end
  if DoesBlipExist(areaBlip)   then RemoveBlip(areaBlip) end
  if vehicle and DoesEntityExist(vehicle) then DeleteEntity(vehicle) end
  if targetPed and DoesEntityExist(targetPed) then DeleteEntity(targetPed) end
end)