# 🎯 Hitman Contracts (FiveM)

Standalone + ESX-compatible contract system for FiveM.  
Players can approach **Fixer NPCs** around the map, accept contracts, and hunt down randomly placed targets. Includes **clues**, **waypoints**, **hint pings**, cinematic intros, and full NUI briefing/tracker UI.

---

## ✨ Features

- 🕵️ **Fixer NPCs**: placed around LS, Sandy, Paleto, etc. with ox_target interactions.
- 📋 **Briefing modal**: cinematic intro + NUI contract sheet with region & intel.
- 🎯 **Targets**:
  - Spawn driving vehicles or walking depending on config.
  - Armed and will fight back.
  - Headshot bonus check.
- 🔍 **Search area**:
  - Yellow blip radius to start hunting.
  - Optional **clues** scattered around; reveal the target after enough are found.
- 🚗 **Waypoint**: auto-sets GPS to the search circle when contract starts.
- 🗺️ **Hint pings**: flashes the target’s blip every 30s (configurable).
- 💰 **Rewards**:
  - ESX: cash, or bank.
  - Standalone: simple notifications only.
- ⏱️ **Cooldowns**: configurable between jobs.
- 🧾 **UI**:
  - Tracker HUD.
  - Toast notifications.
  - Modern CSS styling.

---

## 📦 Requirements

- [ox_lib](https://github.com/overextended/ox_lib)
- [ox_target](https://github.com/overextended/ox_target)
- [es_extended](https://github.com/esx-framework/es_extended) (optional, if using ESX framework)

---

## ⚙️ Installation

1. Download hitman-contracts

2. Add to your `server.cfg`:
   ```cfg
   ensure ox_lib
   ensure ox_target
   ensure es_extended    # if using ESX
   ensure hitman-contracts
   ```

3. Make sure the dependencies start **before** this resource.

---

## 🔧 Configuration

All settings are in `config.lua`.

```lua
-- Framework
Config.Framework = {
  type = 'esx',        -- 'esx' or 'standalone'
  rewardCash = 5000,   -- cash payout
  rewardAccount = nil, -- 'bank' for bank payout
  rewardItem = nil,    -- item reward (e.g. 'markedbills')
  rewardCount = 1,
  failPenaltyCash = 0  -- optional cash penalty on fail
}

-- Brokers (NPC fixers)
Config.Brokers = {
  {
    label = 'Fixer (Del Perro Pier)',
    coords = vec3(-1591.6, -1008.8, 13.0),
    heading = 140.0,
    model = `ig_vincent`,
    scenario = 'WORLD_HUMAN_STAND_MOBILE',
    blip = { sprite = 280, color = 1, scale = 0.8, name = 'Fixer' }
  },
  -- add more...
}
```

---

## 🕹️ Usage

- Walk up to a **Fixer NPC** and use ox_target to interact.
- If available, you’ll see contract dialog (with region + distance).
- Accept → cinematic intro + briefing → search area marked on map.
- Travel there, search clues or close in until target is revealed.
- Eliminate target → contract completes, funds transferred.
- If you fail or die → contract fails, cooldown applied.

---

## 📜 Credits

- **Foaf** – [Github](https://github.com/ArianV)
- [Overextended](https://github.com/overextended) – ox_lib, ox_target, ox_inventory
- [ESX Framework](https://github.com/esx-framework/es_extended)

---

## 📄 License

This resource is provided as-is. You may modify for personal/community use. Please credit the original author when sharing.
