-- qb-parkour / config.lua
Config = {}

-- Toggle & UX
Config.ParkControlsEnabledByDefault = false      -- if true: controls are active on join
Config.ShowCooldownNotifications    = true       -- QBCore notify on cooldown end
Config.CooldownMs                   = 800        -- global anti-spam; per move may override
Config.ChainWindowMs               = 300         -- window to allow chaining into next move

-- Movement tuning (physics multipliers)
Config.Force = {
    Small  = 2.0,
    Medium = 4.0,
    Large  = 7.5
}

-- Bind: we support both keyboard/mouse (group 0) and controller (group 2)
-- Controls are FiveM indices: https://docs.fivem.net/docs/game-references/controls
Config.Keys = {
    PassiveKey = { kbmGroup = 0, kbm = 21,    padGroup = 2, pad = 21 },    -- LEFT SHIFT / Sprint
    ForwardLeap = { kbmGroup = 0, kbm = 47,   padGroup = 2, pad = 191 },   -- G / A (Confirm) as example
    ForwardRoll = { kbmGroup = 0, kbm = 175,  padGroup = 2, pad = 15 },    -- Right Arrow / D-Pad Right
    ForwardSlide= { kbmGroup = 0, kbm = 74,   padGroup = 2, pad = 73 },    -- H / X (Square)
    ForwardDive = { kbmGroup = 0, kbm = 38,   padGroup = 2, pad = 22 },    -- E / Jump
    BackFlip    = { kbmGroup = 0, kbm = 27,   padGroup = 2, pad = 79 },    -- Arrow Up / LS Click (example)
    ForceClimb  = { kbmGroup = 0, kbm = 73,   padGroup = 2, pad = 75 },    -- X / Triangle
    OverJump    = { kbmGroup = 0, kbm = 311,  padGroup = 2, pad = 80 },    -- NUMPAD 8 / RS Click
    LeftLongDive= { kbmGroup = 0, kbm = 117,  padGroup = 2, pad = 16 },    -- Num 7 / D-Pad Up
    ShortLeftDive ={ kbmGroup = 0, kbm = 108, padGroup = 2, pad = 14 },    -- Num 4 / D-Pad Left
    LongRightDive={ kbmGroup = 0, kbm = 118, padGroup = 2, pad = 17 },     -- Num 9 / D-Pad Down
    ShortRightDive={ kbmGroup = 0, kbm = 107, padGroup = 2, pad = 15 },    -- Num 6 / D-Pad Right
    BackwardDive  ={ kbmGroup = 0, kbm = 110, padGroup = 2, pad = 76 },    -- Num 5 / X (example)
}

-- Per-move cooldowns (ms). If nil, uses Config.CooldownMs
Config.MoveCooldown = {
    ForwardLeap = 900,
    ForwardRoll = 700,
    ForwardSlide = 900,
    ForwardDive = 1100,
    BackFlip = 1800,
    ForceClimb = 1000,
    OverJump = 1200,
    LeftLongDive = 1000,
    ShortLeftDive = 850,
    LongRightDive = 1000,
    ShortRightDive = 850,
    BackwardDive = 900,
}

-- Helper to get cooldown
function Config:GetCooldown(move)
    return self.MoveCooldown[move] or self.CooldownMs
end
